﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;


namespace Demo
{
    class adt856
    {
        [DllImport("adt856.dll")]
        public static extern Int32 adt856_initial();
        /*************************功能：初始化卡***************************
        (1)返回值>0时，表示adt856卡的数量。
           如果为3，则下面的可用卡号分别为0、1、2；
        (2)返回值=0时，说明没有安装adt856卡；
        (3)返回值<0时，-1表示没有安装端口驱动程序，-2表示PCI桥故障。
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 adt856_end();
        /***************************功能：释放卡***************************
        返回值	   0：正确			1：错误
        此函数应在程序结束时调用。（仅用于Windows NT/2000）。
        用于将adt856卡占用的资源释放。
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_stop0_mode(Int32 cardno, Int32 axis, Int32 value, Int32 logic);
        /*******************功能：设定stop0输入信号的模式******************
        cardno	   卡号
        axis		轴号（1-4）
        value	    0：无效			1：有效
        logic		0：低电平停止	1：高电平停止
        返回值	    0：正确			1：错误
        默认模式为：：无效，低电平停止
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_stop1_mode(Int32 cardno, Int32 axis, Int32 value, Int32 logic);
        /*******************功能：设定stop1输入信号的模式******************
        cardno	   卡号
        axis		轴号（1-4）
        value	    0：无效			1：有效
        logic		0：低电平停止	1：高电平停止
        返回值	    0：正确			1：错误
        默认模式为：：无效，低电平停止
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_stop2_mode(Int32 cardno, Int32 axis, Int32 value, Int32 logic);
        /*******************功能：设定stop2输入信号的模式******************
        cardno	   卡号
        axis		轴号（1-4）
        value	    0：无效			1：有效
        logic		0：低电平停止	1：高电平停止
        返回值	    0：正确			1：错误
        默认模式为：：无效，低电平停止
        STOP2信号有效时同时可清除实位计数器。
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_actualcount_mode(Int32 cardno, Int32 axis, Int32 value, Int32 dir, Int32 freq);
        /********************功能：设置实位计数器的工作方式****************
        cardno	   卡号
        axis		轴号（1-4）
        value	   输入脉冲方式
                   0：A/B脉冲输入	1：上/下（PPIN/PMIN）脉冲输入
        dir		   计数方向
        0：	A超前B或PPIN脉冲输入向上计数			B超前A或PMIN脉冲输入向下计数
        1： B超前A或PMIN脉冲输入向上计数			A超前B或PPIN脉冲输入向下计数
        freq		A/B脉冲输入时的倍频，上/下脉冲输入时无效
                   0：4倍频
                   1：2倍频
		           2：不倍频
        返回值	   0：正确			1：错误
        默认模式为：A/B相脉冲输入，方向为0，4倍频
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_pulse_mode(Int32 cardno,Int32 axis,Int32 value,Int32 logic,Int32 dir_logic);
        /******************功能：设置输出脉冲的工作方式********************
        cardno	   卡号
        axis		轴号（1-4）
        value 	   0： 脉冲+脉冲方式     1：脉冲+方向方式
        logic	   0：	正逻辑脉冲		 1：	负逻辑脉冲
        dir-logic  0：方向输出信号正逻辑 1：方向输出信号负逻辑
        返回值	   0：正确				 1：错误
        默认模式为：脉冲+方向方式，正逻辑脉冲，方向输出信号正逻辑
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_limit_mode(Int32 cardno,Int32 axis,Int32 value,Int32 logic);
        /************功能：设定正/负方向限位输入nLMT信号的模式设定*********
        cardno	   卡号
        axis		轴号（1-4）
        value		0：有效时立即停止	1：有效时减速停止
        logic		0：低电平有效		1：高电平有效
        返回值	    0：正确				1：错误
        默认模式为：立即停止，低电平有效
        M注意： 限位信号不能设置成有效/无效。
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_softlimit_mode1(Int32 cardno,Int32 axis,Int32 value);
        /*****************功能：COMP+寄存器做软件限制的设定****************
        cardno	   卡号
        axis	    轴号（1-4）
        value	   0：无效				1：有效
        返回值	   0：正确				1：错误
        默认模式为: 无效
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_softlimit_mode2(Int32 cardno,Int32 axis,Int32 value);
        /*****************功能：COMP-寄存器做软件限制的设定****************
        cardno	   卡号
        axis	   轴号（1-4）
        value	   0：无效				1：有效
        返回值	   0：正确				1：错误
        默认模式为: 无效
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_softlimit_mode3(Int32 cardno,Int32 axis,Int32 value);
        /*****************功能：COMP+/-寄存器的比较对象设定****************
        cardno	   卡号
        axis	   轴号（1-4）
        value	   0：逻辑位置计数器	1：实际位置计数器
        返回值	   0：正确				1：错误
        默认模式为 : 逻辑位置计数器
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_inpos_mode(Int32 cardno,Int32 axis,Int32 value,Int32 logic);
        /*******************功能：伺服到位信号nINPOS的设定*****************
        cardno	   卡号
        axis	   轴号（1-4）
        value	   0：无效				1：有效
        logic	   0：低电平有效		1：高电平有效
        返回值	   0：正确				1：错误
        默认模式为 : 无效，低电平有效
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_alarm_mode(Int32 cardno,Int32 axis,Int32 value,Int32 logic);
        /******************功能：伺服报警信号nALARM的设定*******************
        cardno	   卡号
        axis		轴号（1-4）
        value		0：无效					1：有效
        logic		0：低电平有效			1：高电平有效
        返回值	    0：正确					1：错误
        默认模式为 : 无效，低电平有效
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_ad_mode(Int32 cardno,Int32 axis,Int32 value);
        /*********************功能：加/减速方式的设定**********************
        cardno	   卡号
        axis		轴号（1-4）
        value	   0：直线加/减速			1：S曲线加/减速
        返回值	   0：正确					1：错误
        默认模式为 : 直线加/减速
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_dec1_mode(Int32 cardno,Int32 axis,Int32 value);
        /******************功能：非对称梯形加/减速的设定*******************
        cardno	   卡号
        axis		轴号（1-4）
        value	     减速度使用
                   0：加速度的值（即对称加减速）1：减速度的值（即非对称加减速）
        返回值	   0：正确				    	1：错误
        默认模式为 : 对称加减速
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_dec2_mode(Int32 cardno,Int32 axis,Int32 value);
        /***************功能：加/减速定量驱动的减速方式的设定**************
        cardno	   卡号
        axis		轴号（1-4）
        value	   0：自动减速				1：手动减速              
        返回值	   0：正确					1：错误
        默认模式为 : 自动减速
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_circle_mode(Int32 cardno,Int32 axis,Int32 value);
        /*******************功能：计数器的可变环功能的设定*****************
        cardno	   卡号
        axis		轴号（1-4）
        value 	   0：无效					1：有效
        返回值	   0：正确					1：错误
        默认模式为 : 无效
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_input_filter(Int32 cardno,Int32 axis,Int32 number,Int32 value);
        /*******************功能：输入信号滤波功能设置*********************
        cardno	   卡号
        axis		轴号
        number	    输入类别
			        1：LMT+、LMT-、STOP0、STOP1
			        2：STOP2
			        3：nINPOS、nALARM
			        4：nIN
			        即可分别设置上面四类输入信号的滤波状态
        value		0：滤波无效			    1：滤波有效
        默认模式为 : 无效
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_filter_time(Int32 cardno,Int32 axis,Int32 value);
        /******************功能：输入信号滤波时间常数设置卡****************
        cardno	   卡号
        axis		轴号
        value	    可以除去最大噪音幅度(范围)   输入信号延迟(范围)
        ******************************************************************/

        //----------------------------------------------------//
        //               驱动状态检查函数                     //
        //----------------------------------------------------//

        [DllImport("adt856.dll")]
        public static extern Int32 get_status(Int32 cardno,Int32 axis,out Int32 value);
        /*********************功能：获取各轴的驱动状态*********************
        cardno	   卡号
        axis		轴号（1-4）
        value		驱动状态的指针
                    0：驱动结束             非0：value为两个字节长度的值
        返回值	    0：正确					1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 get_stopdata(Int32 cardno,Int32 axis,out Int32 value);
        /*********************功能：获取各轴的错误停止信息*****************
        cardno	   卡号
        axis		轴号
        value	   错误状态的指针
	 		        0：无错误                非0：value为两个字节长度的值
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 get_inp_status(Int32 cardno,Int32 no,out Int32 value);
        /*********************功能：获取插补的驱动状态*********************
        cardno	   卡号
        no		   1：X-Y轴插补或3轴以上插补   2：Z-W轴插补
        value	    插补状态的指针
			        0：插补结束			       1：正在插补
        返回值	    0：正确					   1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 get_inp_status2(Int32 cardno,Int32 no,out Int32 value);
        /*******************功能：取连续插补的允许写入状态*****************
        cardno	   卡号
        no		   1：X-Y轴插补或3轴以上插补   2：Z-W轴插补
        value	   状态的指针
		           0：不允许写入				1：允许写入
        返回值	   0：正确				    	1：错误
        ******************************************************************/


        //----------------------------------------------------//
        //               运动参数设定函数                     //
        //----------------------------------------------------//

        [DllImport("adt856.dll")]
        public static extern Int32 set_range(Int32 cardno, Int32 axis,Int32 Value);
        /*************************功能： 范围设定***************************
        cardno	   卡号
        axis		轴号
        value	   R值 范围（8000000-16000）
        返回值	   0：正确				1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_acac(Int32 cardno, Int32 axis,Int32 Value);
        /*******************功能：加/减速度的变化率设定********************
        cardno	   卡号
        axis		轴号
        value	    K值（1-65535）
        返回值	   0：正确				1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_acc(Int32 cardno, Int32 axis,Int32 Value);
        /************************功能：加速度设定**************************
        cardno	   卡号
        axis		轴号
        value	    A值（1-8000）
        返回值	    0：正确				1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_dec(Int32 cardno, Int32 axis,Int32 Value);
        /************************功能：减速度设定**************************
        cardno	   卡号
        axis		轴号
        value	    D值（1-8000）
        返回值	    0：正确				1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_startv(Int32 cardno, Int32 axis,Int32 Value);
        /***********************功能：初始速度设定*************************
        cardno	   卡号
        axis		轴号
        value       SV值（1-8000）
        返回值	    0：正确				1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_speed(Int32 cardno, Int32 axis,Int32 Value);
        /***********************功能：驱动速度设定*************************
        cardno	   卡号
        axis		轴号
        value	   V值（1-8000）
        返回值	   0：正确				1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_command_pos(Int32 cardno, Int32 axis,Int32 Value);
        /**********************功能：逻辑位置计数器设定********************
        cardno	   卡号
        axis		轴号
        value	   范围值（-2147483648~+2147483647）
        返回值	   0：正确				1：错误
        逻辑位置计数器任何时候都能写、任何时候都能读
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_actual_pos(Int32 cardno, Int32 axis,Int32 Value);
        /*********************功能：实际位置计数器设定*********************
        cardno	   卡号
        axis		轴号
        value	   范围值（-2147483648~+2147483647）
        返回值	   0：正确				1：错误
        实际位置计数器任何时候都能写、任何时候都能读
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_comp1(Int32 cardno, Int32 axis,Int32 Value);
        /**********************功能：COMP+寄存器设定***********************
        cardno	   卡号
        axis		轴号
        value       范围值（-2147483648~+2147483647）
        返回值	   0：正确				1：错误
        COMP+寄存器任何时候都能写
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_comp2(Int32 cardno, Int32 axis,Int32 Value);
        /**********************功能：COMP-寄存器设定***********************
        cardno	   卡号
        axis		轴号
        value	   范围值（-2147483648~+2147483647）
        返回值	   0：正确				1：错误
        COMP-寄存器任何时候都能写
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 set_dec_pos(Int32 cardno, Int32 axis,Int32 Value);
        /**********************功能：手动减速点设定***********************
        cardno	   卡号
        axis		轴号
        value	   范围值（0~268435455）
        返回值	   0：正确				1：错误
        在使用手动减速模式时必须设定好手动减速点
        ******************************************************************/

        //----------------------------------------------------//
        //               运动参数检查函数                     //
        //----------------------------------------------------//

        [DllImport("adt856.dll")]
        public static extern Int32 get_command_pos(Int32 cardno,Int32 axis,out Int32 pos);
        /********************功能：获取各轴的逻辑位置卡********************
        cardno	   卡号
        axis		轴号
        pos		   逻辑位置值的指针
        返回值	   0：正确			1：错误
        此函数可随时得到轴的逻辑位置，在电机未失步的情况下，pos的值表示轴的当前位置。
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 get_actual_pos(Int32 cardno,Int32 axis,out Int32 pos);
        /********************功能：获取各轴的实际位置**********************
        cardno	   卡号
        axis		轴号
        pos		   实际位置值的指针
        返回值		0：正确			1：错误
        此函数可随时得到轴的实际位置，在电机有失步的情况下，pos的值依然表示轴的实际位置。
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 get_speed(Int32 cardno,Int32 axis,out Int32 pos);
        /*******************功能：获取各轴的当前驱动速度*******************
        cardno	   卡号
        axis		轴号
        pos	        当前驱动速度的指针
        返回值		0：正确			1：错误
        数据的单位和驱动设定数值V一样。
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 get_ad(Int32 cardno,Int32 axis,out Int32 pos);
        /*******************功能：获取各轴的当前加速度*********************
        cardno	   卡号
        axis		轴号
        pos		   当前加速度的指针
        返回值		0：正确			1：错误
        数据的单位和驱动加速度设定数值A一样
        ******************************************************************/


        //----------------------------------------------------//
        //                   驱动函数                         //
        //----------------------------------------------------//

        [DllImport("adt856.dll")]
        public static extern Int32 pmove(Int32 cardno,Int32 axis,Int32 pulse);
        /*************************功能：定量驱动***************************
        cardno 	   卡号
        axis		轴号
        pulse 	   输出的脉冲数            范围（-268435455~+268435455）
		           >0：正方向移动		   <0：负方向移动
        返回值	   0：正确				    1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 continue_move(Int32 cardno,Int32 axis,Int32 dir);
        /*************************功能：连续驱动***************************
        cardno 	   卡号
        axis		轴号
        dir		   驱动的方向
		           0：正方向移动		   1：负方向移动
        返回值	   0：正确				   1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 dec_stop(Int32 cardno,Int32 axis);
        /***********************功能：驱动减速停止*************************
        cradno	   卡号
        axis		轴号
        返回值	   0：正确				1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 sudden_stop(Int32 cardno,Int32 axis);
        /************************功能：驱动立即停止************************
        cardno	   卡号
        axis		轴号
        返回值	   0：正确				1：错误
        立即停止正在驱动中的脉冲输出，在加/减速驱动中也立即停止。
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 inp_move2(Int32 cardno,Int32 no,Int32 pulse1,Int32 pulse2);
        /***********************功能：两轴直线插补************************
        cardno	   卡号
        no		   参与插补的轴号         1：X-Y              2：Z-W
        pulse1,pulse2	移动的相对距离    范围（-8388608~+8388607）
        返回值	   0：正确			  	  1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 inp_cw_arc(Int32 cardno, Int32 no, Int32 x, Int32 y, Int32 i, Int32 j);
        /*********************功能：顺时针CW圆弧插补***********************
        cardno	   卡号
        no		   参与插补的轴号         1：X-Y              2：Z-W
        x,y		   圆弧插补的终点位置（相对于起点） 	   范围（-8388608~+8388607）
        i,j		   圆弧插补的圆心点位置（相对于起点）      范围（-8388608~+8388607）
        返回值	   0：正确		 		  1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 inp_ccw_arc(Int32 cardno, Int32 no, Int32 x, Int32 y, Int32 i, Int32 j);
        /**********************功能：逆时针CCW圆弧插补*********************
        cardno	   卡号
        no		   1：X-Y                 2：Z-W
        x,y		   圆弧插补的终点位置（相对于起点）        范围（-8388608~+8388607）
        i,j	 	   圆弧插补的圆心点位置（相对于起点）      范围（-8388608~+8388607）
        返回值	   0：正确				  1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 inp_move3(Int32 cardno,Int32 pulse1,Int32 pulse2,Int32 pulse3);
        /***********************功能：三轴直线插补*************************
        cardno 	   卡号
        pulse1,pulse2,pulse3				   X-Y-Z轴移动的相对距离
        范围（-8388608~+8388607）
        三轴插补只能进行X、Y、Z轴三轴插补
        返回值	   0：正确				  1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 inp_move4(Int32 cardno,Int32 pulse1,Int32 pulse2,Int32 pulse3,Int32 pulse4);
        /***********************功能：四轴直线插补*************************
        cardno 	   卡号
        pulse1,pulse2,pulse3,pulse4				X-Y-Z-W轴移动的相对距离
        范围（-8388608~+8388607）
        返回值	   0：正确				      1：错误

        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 inp_move6(Int32 cardno, Int32 pulse1, Int32 pulse2, Int32 pulse3, Int32 pulse4 ,Int32 pulse5, Int32 pulse6);
        /***********************功能：四轴直线插补*************************
        cardno 	   卡号
        pulse1,pulse2,pulse3,pulse4,pulse5,pulse6				X-Y-Z-W-U-V轴移动的相对距离
        范围（-8388608~+8388607）
        返回值	   0：正确				      1：错误

        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 inp_dec_enable(Int32 cardno, Int32 no);
        /***********************功能：插补减速允许*************************
        cardno	   卡号
        no		   1：X-Y或X-Y-Z或X-Y-Z-W插补 2：Z-W插补
        返回值	   0：正确			  	      1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 inp_dec_disable(Int32 cardno, Int32 no);
        /***********************功能：插补减速禁止*************************
        cardno	   卡号
        no		    1：X-Y或X-Y-Z或X-Y-Z-W插补		2：Z-W插补
        返回值	    0：正确			 	     1：错误
        ******************************************************************/


        //----------------------------------------------------//
        //                开关量输入/输出函数                 //
        //----------------------------------------------------//

        [DllImport("adt856.dll")]
        public static extern Int32 read_bit(Int32 cardno,Int32 number);
        /************************功能：读单个输入点************************
        cardno	   卡号
        number	   输入点（0-31）
        返回值	   0：低电平		   1：高电平		   -1：错误
        ******************************************************************/

        [DllImport("adt856.dll")]
        public static extern Int32 write_bit(Int32 cardno,Int32 number,Int32 value);
        /***************************功能：输出单点 ************************
        cardno	   卡号
        number	   输出点（0-31）
        value	   0：低		        1：高
        返回值	   0：正确 				1：错误
        输出数对应相应的输出号。
        ******************************************************************/

    }
}
